import acm.program.*;
import acm.graphics.*;
import acm.util.*;

public class FlipVertical extends GraphicsProgram {

    public void run() {
	    	GImage img = new GImage("res/karel.png");
	    	flipVertical(img);
	    	add(img);
    }
    
    public void flipVertical(GImage image) {
        int[][] pixels = image.getPixelArray();
        int width = pixels[0].length;
        int height = pixels.length;
        for (int col = 0; col < width; col++) {
            for (int p1 = 0; p1 < height / 2; p1++) {
                int p2 = height - p1 - 1;
                int temp = pixels[p1][col];
                pixels[p1][col] = pixels[p2][col];
                pixels[p2][col] = temp;
            }
        }
        image.setPixelArray(pixels);
    }



}