import acm.program.*;

/* Computes prime numbers using the Sieve of Eratosthenes */

public class Sieve extends ConsoleProgram {
	// The value up to which we should find prime numbers.
	private static final int UPPER_LIMIT = 1000;
	public void run() {
		// Create an array of booleans that track if we have crossed off
		// each number. Initially, each number has not been crossed off, so all
		// the booleans to all be false. This is what Java does by default,
		// but for robustness we will explicitly set each to false.

		// crossedOff[i] represents the number i + 2
		boolean[] crossedOff = new boolean[UPPER_LIMIT  - 1];
        for (int i = 0; i < crossedOff.length; i++) {
            crossedOff[i] = false;
        }

		for (int n = 0; n < crossedOff.length; n++) {
			if (!crossedOff[n]) {
				println(n + 2);
				// Cross off all the multiples of n.
				for (int k = n; k < crossedOff.length; k += n + 2) {
					crossedOff[k] = true;
				}
			}
		}
	}
}
