import acm.program.*;
import acm.graphics.*;
import acm.util.*;

public class Stretch extends GraphicsProgram {

    public void run() {
	    	GImage img = new GImage("res/karel.png");
	    	stretch(img, 4);
	    	add(img);
    }
    
    public void stretch(GImage image, int factor) {
        int[][] pixels = image.getPixelArray();
        int[][] result = new int[pixels.length][pixels[0].length * factor];
        for (int row = 0; row < result.length; row++) {
            for (int col = 0; col < result[0].length; col++) {
                result[row][col] = pixels[row][col / factor];
            }
        }
        image.setPixelArray(result);
    }




}