/*
 * File: Airport.java
 * ------------------
 * This program manages and dispatches Airplanes.
 */

import acm.program.*;
import java.util.*;

public class Airport extends ConsoleProgram {

	ArrayList<Airplane> planes;

	public void run() {
		planes = new ArrayList<Airplane>();

		// build 3 airplanes
		for (int i = 0; i < 3; i++) {
			println("Airport log: adding plane");
			Airplane plane = new Airplane();
			planes.add(plane);
		}

		// tell 2 to depart
		for (int i = 0; i < 2; i++) {
			dispatchPlane();
		}

		// build one more plane - can do this in 1 line below, or like above
		println("Airport log: adding plane");
		planes.add(new Airplane());

		// tell all planes to depart
		while (!planes.isEmpty()) {
			dispatchPlane();
		}
	}

	private void dispatchPlane() {
		println("Airport log: dispatching plane");
		Airplane plane = planes.get(0);

		// just an example of error-checking using Airplane's "getter" method
		if (plane.isAirborne()) {
			println("Airport log: ERROR - plane already airborne");
		}
		plane.takeOff();
		planes.remove(0);
	}
}
