/* File: CountNames.java
 * ---------------------
 * This program reads a list of names from the user and lists out
 * how many times each name appeared in the list.
 */

import acm.program.*;
import java.util.*;

public class CountNames extends ConsoleProgram {
    
    public void run() {
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        readNames(nameMap);
        printMap(nameMap);
    }

    /*
     * Reads a list of names from the user, storing names and how many
     * times each appeared in the map that is passed in as a parameter.
     */
    private void readNames(Map<String, Integer> map) {
        while (true) {
            String name = readLine("Enter name: ");
            if (name.equals("")) break;

            // See if that name previously appeared in the map.  Update
            // count if it did, or create a new count if it didn't.
            int count;
            if (map.containsKey(name)) {
                // get old value of count, and create a new value for count
                // that is 1 greater than old value
                count = map.get(name) + 1;
            } else {
                // create a new int with value 1
                count = 1;
            }
            map.put(name, count);
        }
    }

    /*
     * Prints out list of entries (and associated counts) from the map
     * that is passed in as a parameter.
     */
    private void printMap(Map<String, Integer> map) {
        for (String key : map.keySet()) {
            int count = map.get(key);
            println("Entry [" + key + "] has count " + count);
        }
    }
}
