// Student object reps. a Stanford student w/ name, ID, and unit count.
public class Student {
    private String name;           /* The student’s name */
    private int ID;                /* The student’s ID number */
    private double unitsEarned;    /* number of units student has */

    /** Constant: the number of units required for graduation */
    public static final double UNITS_TO_GRADUATE = 180.0;

    // Creates a new student object with given name, ID, and 0 units.
    public Student(String studentName, int studentID) {
        name = studentName;
        ID = studentID;
        unitsEarned = 0;
    }

    // Returns the name of this student.
    public String getName() {
        return name;
    }

    // Returns the ID number of this student.
    public int getID() {
        return ID;
    }

    // Returns the number of units earned.
    public double getUnits() {
        return unitsEarned;
    }

    // Increments the earned units by the given number of units.
    public void incrementUnits(double additionalUnits) {
        unitsEarned += additionalUnits;
    }

    // Returns whether or not the student has enough units to graduate.
    public boolean hasEnoughUnits() {
        return unitsEarned >= UNITS_TO_GRADUATE;
    }

    // Creates a string IDing this student, such as "Marty (#223)".
    public String toString() {
        return name + " (#" + ID + ")";
    }
}
