#!/usr/bin/env python3

"""
Stanford CS106A Crazy-Cat Example
Nick Parlante

3 Command line argument forms:
  filename
  -crazy filename
  -vowels filename

Demonstrates file-reading and printing like "cat".
Demonstrates a main() that looks at command line arg strings.
The -crazy and -vowels features shows a string functions
with Doctests.
"""

import sys


def print_file_plain(filename):
    """
    Given a filename, read all its lines and print them out.
    This shows the plain, canonical file-reading loop.
    """
    with open(filename) as f:
        for line in f:
            print(line, end='')


# Why is end='' needed here?
# The end='' is needed because the "line" string already has a \n char at its end,
# and print also puts a \n after what it prints, so the output would be double-spaced.
# The end='' option tells print() to omit the \n it usually adds.


def crazy_line(line):
    """
    Given a line of text, returns a "crazy" version of that line,
    where upper/lower case have all been swapped, so 'Hello'
    returns 'hELLO'.
    >>> crazy_line('Hello')
    'hELLO'
    >>> crazy_line('@xYz!')
    '@XyZ!'
    >>> crazy_line('')
    ''
    """
    result = ''
    for i in range(len(line)):
        char = line[i]
        if char.islower():
            result += char.upper()
        else:
            result += char.lower()
    return result


def print_file_crazy(filename):
    """
    Given a filename, read all its lines and print them out
    in crazy form.
    """
    with open(filename) as f:
        for line in f:
            print(crazy_line(line), end='')


def count_vowels(line):
    """
    Given a string line of text, returns the
    count of 'a' 'e' 'i' 'o' 'u' in line.
    >>> count_vowels('xxaeiouxx')
    5
    >>> count_vowels('AaEEEU')
    6
    >>> count_vowels('')
    0
    """
    count = 0
    for i in range(len(line)):
        low = line[i].lower()
        # Trick use of "in" here, replacing low=='a' or low=='e'...
        if low in 'aeiou':
            count += 1
    return count


def print_file_vowels(filename):
    """
    Given a filename, read and print out all its lines,
    including the vowel-count with each line.
    """
    with open(filename, 'r') as f:
        for line in f:
            vowels = count_vowels(line)
            print(vowels, line,  end='')


def main():
    args = sys.argv[1:]
    # Code here looks at command line arguments and calls functions
    # filename  -> calls print_file_plain()
    # -crazy filename -> calls print_file_crazy()
    # -vowels filename -> calls print_file_vowels()
    if len(args) == 1:
        # args[0] is filename
        print_file_plain(args[0])

    if len(args) == 2 and args[0] == '-crazy':
        print_file_crazy(args[1])

    if len(args) == 2 and args[0] == '-vowels':
        print_file_vowels(args[1])


# Standard call-main() boilerplate at end of file.
if __name__ == '__main__':
    main()
