#!/usr/bin/env python3

"""
Stanford CS106A Traffic Jupyter Example
This is standard looking code to parse
the traffic data into a dict.
"""

import sys


"""
Traffic data file looks like:

day_of_year,hour_of_day,time_in_secs
01-01-18,0,2549
01-01-18,1,2751
01-01-18,2,2248
01-01-18,3,2440

We'll say a "times" dict has hour keys 0..23
and the value for each key is the time
consumed in that hour in seconds.
"""


def read_times(filename):
    """
    Read filename into a "times" dict.
    >>> times = read_times('test.txt')
    >>> times[0]
    2
    >>> times[1]
    4
    """
    with open(filename, 'r') as f:
        lines = f.readlines()
    lines.pop(0)  # first line is not data
    times = {}
    for hour in range(24):
        times[hour] = 0

    for line in lines:
        splits = line.split(",")
        hour = int(splits[1])
        time = int(splits[2])
        times[hour] += time
    return times


def div_times(times, n):
    """Divides the times by given n and return the new dict."""
    for key in times.keys():
        times[key] /= n
    return times


def main():
    # (provided)
    args = sys.argv[1:]
    times = read_times(args[0])
    print(times)

if __name__ == '__main__':
    main()
