"""
File: stanford.py
-----------------
This program provides an example of using Student objects
"""


from student import Student


CS106A_UNITS = 5


def print_units(s):
    """
    Prints the name and number of units that student s has,
    as well as whether the student can graduate.
    """
    print(f"{s.get_name()} has {s.get_units()} units")
    print(f"{s.get_name()} can graduate: {s.can_graduate()}")


def take_cs106a(s):
    """
    States that student s takes CS106A and increments number of units
    """
    print(f"{s.get_name()} takes CS106A!!")
    s.increment_units(CS106A_UNITS)


def main():
    wil = Student("Wil Kautz", 38000000)
    wil.set_units(3)
    print_units(wil)

    chris = Student("Chris Gregg", 55000000)
    chris.set_units(179)
    print_units(chris)

    take_cs106a(wil)
    take_cs106a(chris)

    print_units(wil)
    print_units(chris)


if __name__ == '__main__':
    main()
