import SimpleServer
import json

# classes are our friends!
class ChatServer:
    def __init__(self):
        self.history = []

    # this is the server request callback function. You can't change its form
    def handle_request(self, request):

        # addMsg, getMsgs
        print(request)
        cmd = request.get_command()
        params = request.get_params()
        if cmd == 'newMsg':
            return self.add_message(params)
        if cmd == 'getMsgs':
            return self.get_messages(params)
        return 'unknown command'

    def add_message(self, params):
        msg = params['msg']
        user = params['user']
        self.history.append('[' + user + ']' + msg)
        return 'success'

    def get_messages(self, params):
        index = int(params['index'])
        return json.dumps(self.history[index:])

def main():
    # make the server
    handler = ChatServer()
    # start the server to handle internet requests!
    SimpleServer.run_server(handler, 8000)

if __name__ == '__main__':
    main()