def list_comprenensions():
    my_list = [15, 50, 10, 17, 5, 29, 22, 37, 38, 15]
    print(f"original list: {my_list}")
    new_list = [2 * x for x in my_list]
    print(f"new_list: {new_list}")

    print()
    new_list = [x for x in my_list if x < 30]
    print(f"new_list: {new_list}")
    print()

    new_list = [-x for x in my_list]
    print(f"new_list: {new_list}")

    print()


def zip_examples():
    list1 = ['a', 'b', 'c', 'd', 'e']
    list2 = [10, 20, 30, 40, 50]
    for v1, v2 in zip(list1, list2):
        print(v1, v2)

    print()
    s1 = "a string"
    s2 = "second string"
    for v1, v2 in zip(s1, s2):
        print(v1, v2)

    print()
    s1 = "the"
    s2 = "cat"
    s3 = "the"
    s4 = "bat"
    s5 = "the"
    s6 = "rat"
    print(list(zip(s1, s2, s3, s4, s5, s6)))
    print()


def set_examples():
    my_set = set()
    for c in 'Mississippi':
        my_set.add(c)
    print(my_set)
    print('s' in my_set)

    print()
    first_three = {1, 2, 3}
    evens = {2, 4, 6}
    wholes = {0, 1, 2, 3, 4, 5, 6, 7}
    print(first_three.union(evens))
    print(first_three.intersection(evens))
    print(first_three.difference(evens))
    print(first_three.issubset(wholes))
    print(wholes.issuperset(evens))
    print()


def dictionary_comprehensions():
    dict1 = {'a': 1, 'b': 2, 'c': 3, 'd': 4, 'e': 5}

    # Double each value in the dictionary
    double_dict1 = {k: v * 2 for (k, v) in dict1.items()}
    print(f"original dict: {dict1}")
    print(f"new dict:      {double_dict1}")

    print()
    d = {'a': 5, 'b': 6, 'c': 7}
    d_xkeys = {k + 'x': v for (k, v) in d.items()}
    print(d_xkeys)

    print()
    d = {1: 'a', 2: 'b', 3: 'c', 4: 'd', 5: 'e'}
    d_mod = {k % 3: v for (k, v) in d.items()}
    print(f"original dict: {d}")
    print(f"new dict:      {d_mod}")
    print()


def enumerate_examples():
    xyz = ['x', 'y', 'z']
    print("old way:")
    for i in range(len(xyz)):
        value = xyz[i]
        print(f"{i}: {value}")

    print("using enumerate:")
    for i, value in enumerate(xyz):
        print(f"{i}: {value}")

    print()




def try_except_examples():
    pass

def main():
    list_comprenensions()
    zip_examples()
    set_examples()
    dictionary_comprehensions()
    enumerate_examples()
    try_except_examples()


if __name__ == "__main__":
    main()