from karel.stanfordkarel import *

"""
File: DemocracyKarel.py
--------------------
When you finish writing this file, DemocracyKarel should be
able to find and fix the hanging-chad problem, while leaving
alone the columns that the voter did not want to vote for.
"""


def main():
    """
    To avoid the fencepost problem, we split the
    logic into a loop to process columns, plus one
    final call to check the last column.
    """
    while front_is_clear():
        process_column()
        move()
    process_column()


def process_column():
    """
    Clears chad from the current column, if any.
    Precondition: Karel is standing in the center of a column, facing East.
    Postcondition: Karel is back in the same place/orientation and chad has been cleared
    """
    if no_beepers_present():
        remove_all_chad()


def remove_all_chad():
    """
    Clears chad from the current column
    Precondition: Karel is standing in the center of a column to be cleared
    Postcondition: Karel is standing in the same place and the column has been cleared
    """
    turn_left()  # clean the upper corner
    clean_chad()
    turn_around()  # clean the lower corner
    clean_chad()
    turn_left()  # face East


def clean_chad():
    """
    Clears chad from the corner Karel is facing
    Precondition: Karel is facing a corner to be cleared of chad
    Postcondition: Karel is in the same location/orientation, but
    all chad has been cleared from the corner Karel is facing.
    """
    move()
    while beepers_present():
        pick_beeper()
    back_up()

def back_up():
    """
    Backs up one corner, leaving Karel facing in the same
    direction. If there is no space behind Karel, it will run
    into a wall.
    """
    turn_around()
    move()
    turn_around()


def turn_around():
    turn_left()
    turn_left()


# There is no need to edit code beyond this point

if __name__ == "__main__":
    run_karel_program()
