from karel.stanfordkarel import *

"""
File: HospitalKarel.py
--------------------
When you finish writing this file, HospitalKarel should be
able to locate the hospital markers and build a hospital
on those locations.
"""
def turn_around():
    turn_left()
    turn_left()

def turn_right():
    turn_around()
    turn_left()


def main():
    while front_is_clear():
        if beepers_present():
            build_hospital()
        if front_is_clear():
            move()  # Karel needs to be facing East

def build_hospital():
    """
    Precondition: Karel is on a beeper representing supplies for a hospital
    Postcondition: Karel is facing East
    """
    pick_beeper()
    back_up()
    turn_left()
    place_three_beepers()
    transition_to_next_column()
    place_three_beepers()
    turn_around()
    transition_to_next_column()
    place_three_beepers()
    turn_left()



def place_three_beepers():
    """
    Creates a line of three beepers
    Precondition: Karel is in the first square in the line
    Postcondition: Karel is in the last square in the line
    """
    for i in range(2):
        put_beeper()
        move()
    put_beeper()

def back_up():
    """
    Backs up one corner, facing in the same direction
    """
    turn_around()
    move()
    turn_around()

def transition_to_next_column():
    move()
    turn_right()
    move()
    turn_right()

# There is no need to edit code beyond this point

if __name__ == "__main__":
    run_karel_program()
