"""
File: pyramid.py
----------------
YOUR DESCRIPTION HERE
"""


import tkinter
import time
from graphics import Canvas

CANVAS_WIDTH = 600      # Width of drawing canvas in pixels
CANVAS_HEIGHT = 600     # Height of drawing canvas in pixels
CHANGE_X_START = 10
CHANGE_Y_START = 7
BALL_SIZE = 70


def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Bouncing Ball')

    ball = canvas.create_oval(0, 0, BALL_SIZE, BALL_SIZE, fill='blue', outline='blue')

    dx = CHANGE_X_START
    dy = CHANGE_Y_START
    while True:
        # update world
        canvas.move(ball, dx, dy)
        if hit_left_wall(canvas, ball) or hit_right_wall(canvas, ball):
            dx *= -1
        if hit_top_wall(canvas, ball) or hit_bottom_wall(canvas, ball):
            dy *= -1
        # redraw canvas
        canvas.update()
        # pause
        time.sleep(1/50.)


def hit_left_wall(canvas, object):
    return canvas.get_left_x(object) <= 0


def hit_top_wall(canvas, object):
    return canvas.get_top_y(object) <= 0


def hit_right_wall(canvas, object):
    return canvas.get_left_x(object) + BALL_SIZE >= CANVAS_WIDTH


def hit_bottom_wall(canvas, object):
    return canvas.get_top_y(object) + BALL_SIZE >= CANVAS_HEIGHT


if __name__ == '__main__':
    main()
