"""
File: pyramid.py
----------------
YOUR DESCRIPTION HERE
"""


import tkinter
import time
from graphics import Canvas

CANVAS_WIDTH = 600      # Width of drawing canvas in pixels
CANVAS_HEIGHT = 600     # Height of drawing canvas in pixels
SQUARE_SIZE = 70


def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Move Square')
    # make the rectangle...
    start_y = CANVAS_HEIGHT / 2 - SQUARE_SIZE / 2
    end_y = start_y + SQUARE_SIZE
    rect = canvas.create_rectangle(0, start_y, SQUARE_SIZE, end_y, fill='black')

    # animation loop
    while not is_past_middle(canvas, rect):
        # update the world
        canvas.move(rect, 1, 0)
        canvas.update()

        # pause
        time.sleep(1/50.) #parameter is seconds to pause.
    canvas.mainloop()


def is_past_middle(canvas, rect):
    max_x = CANVAS_WIDTH / 2 - SQUARE_SIZE / 2
    curr_x = canvas.get_left_x(rect)
    return curr_x > max_x


if __name__ == '__main__':
    main()
