import tkinter
import time
import math
from graphics import Canvas

CANVAS_WIDTH = 600      # Width of drawing canvas in pixels
CANVAS_HEIGHT = 600     # Height of drawing canvas in pixels

PADDLE_Y = CANVAS_HEIGHT - 60
PADDLE_WIDTH = 100
PADDLE_HEIGHT = 20
BALL_SIZE = 70

def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Pong 1')

    ball = canvas.create_oval(0, 0, BALL_SIZE, BALL_SIZE, fill='red', outline='red')
    # TODO: 1. we now make a paddle
    paddle = canvas.create_rectangle(0, PADDLE_Y, PADDLE_WIDTH, PADDLE_Y + PADDLE_HEIGHT, fill="blue")

    dx = 10
    dy = 7
    while True:
        # TODO: 2. get the mouse location and react to it
        mouse_x = canvas.get_mouse_x()
        canvas.moveto(paddle, mouse_x, PADDLE_Y)

        canvas.move(ball, dx, dy)
        if hit_left_wall(canvas, ball) or hit_right_wall(canvas, ball):
            dx *= -1
        if hit_top_wall(canvas, ball):
            dy *= -1

        # TODO: 3. check if the ball hits the paddle
        if hit_paddle(canvas, ball, paddle):
            dy = -abs(dy)
        # redraw canvas
        canvas.update()
        # pause
        time.sleep(1/50.)


def hit_paddle(canvas, ball, paddle):
    # TODO: paddle_coords is of type list. Come to lecture Monday!
    paddle_coords = canvas.coords(paddle)
    x1 = paddle_coords[0]
    y1 = paddle_coords[1]
    x2 = paddle_coords[2]
    y2 = paddle_coords[3]
    results = canvas.find_overlapping(x1, y1, x2, y2)
    return len(results) > 1


def hit_left_wall(canvas, object):
    return canvas.get_left_x(object) <= 0


def hit_top_wall(canvas, object):
    return canvas.get_top_y(object) <= 0


def hit_right_wall(canvas, object):
    return canvas.get_left_x(object) + BALL_SIZE >= CANVAS_WIDTH


def hit_bottom_wall(canvas, object):
    return canvas.get_top_y(object) + BALL_SIZE >= CANVAS_HEIGHT


if __name__ == '__main__':
    main()
