import tkinter
from graphics import Canvas
import time

# Make the window large so that we can see more detail. 
CANVAS_WIDTH = 1000;
CANVAS_HEIGHT = 750;

# The viewpoint coordinates - the min and max long and lat
MIN_LONGITUDE = -130;
MAX_LONGITUDE = -60;
MIN_LATITUDE = +22;
MAX_LATITUDE = +55;

def main():
	# get a drawing canvas
	canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'US Cities')

	# an example call to plot one city
	plot_one_city(canvas, 31.566367, -85.251300)

	# keep the window open
	canvas.mainloop()


'''
Given the longitude and latitude of a city (in double form), displays
a dot for that city.
'''
def plot_one_city(canvas, latitude, longitude) :
	# Determine where on screen the city should be drawn. 
	x = longitude_to_x(longitude)
	y = latitude_to_y(latitude)
	plot_pixel(canvas, x, y)

'''
Plots a pixel at the specified (x, y) coordinate.'''
def plot_pixel(canvas, x, y):
	# Create a 1x1 rectangle
	canvas.create_rectangle(x, y, x+1, y+1, fill="blue", outline="blue")

'''
Given a raw longitude, returns the screen x coordinate where
it should be displayed.
'''
def longitude_to_x(longitude):
	return CANVAS_WIDTH * (longitude - MIN_LONGITUDE) / (MAX_LONGITUDE - MIN_LONGITUDE)

'''
Given a raw latitude, returns the screen y coordinate where
it should be displayed.
'''
def latitude_to_y(latitude):
	return CANVAS_HEIGHT * (1.0 - (latitude - MIN_LATITUDE) / (MAX_LATITUDE - MIN_LATITUDE))


if __name__ == '__main__':
	main()