import random
from constants import *

"""
This is the blueprint for a new variable type called "Ball"
Every ball has three things: an oval, a change_x and a change_y.
Every ball supports the "update" method which will move the ball one step.

When defining a new variable type you must specify:
(1) What happens when you create a new instance?
(2) What sub-variables does every instance have?
(3) What methods (aka functions) can you call on an instance?
"""

class Ball:

    # (1) This defines the "constructor": what happens when you make a new
    # instance of type Ball. Note the use of 'canvas' as a parameter!
    def __init__(self, canvas):
        # When making a new ball, first chose its location.
        x_1 = random.randint(0, CANVAS_WIDTH - BALL_SIZE)
        y_1 = random.randint(0, CANVAS_HEIGHT - BALL_SIZE)
        x_2 = x_1 + BALL_SIZE
        y_2 = y_1 + BALL_SIZE

        # (2) These lines define the three "instance variables":
        # variables that each "instance" has.
        self.oval = canvas.create_oval(x_1, y_1, x_2, y_2, fill='blue', outline='blue')
        self.change_x = random.randint(5, 15)
        self.change_y = random.randint(5, 15)

    # (3) This defines an instance method you can call on any instance of type Ball.
    # Again, I pass in canvas. Good times.
    def update(self, canvas):
        # update a single ball instance (the one given by self)
        canvas.move(self.oval, self.change_x, self.change_y)
        if self._hit_left_or_right_wall(canvas):
            self.change_x *= -1

        if self._hit_top_or_bottom_wall(canvas):
            self.change_y *= -1

    # These are "private" Instance Methods:
    # You can call these helpers on any Ball, but to make it clear that I
    # only want to call them "internally" I start the name with an '_'
    def _hit_left_or_right_wall(self, canvas):
        # this is a tkinter function which gets the coordinates of a shape
        # the first element in the returned list is the x value of the left
        # of the shape
        ball_x = canvas.get_left_x(self.oval)
        return ball_x < 0 or ball_x > CANVAS_WIDTH - BALL_SIZE

    def _hit_top_or_bottom_wall(self, canvas):
        # the second element in the returned list is the y value of the top
        ball_y = canvas.get_top_y(self.oval)
        return ball_y < 0 or ball_y > CANVAS_HEIGHT - BALL_SIZE