import tkinter
import time
from graphics import Canvas
from constants import *
from ball import Ball

N_BALLS = 2

def main():
    # gotta have a canvas!
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Bouncing Ball')
    balls = create_balls(canvas)
    while True:
        # update world
        for ball in balls:
            ball.update(canvas)
        # redraw canvas
        canvas.update()
        time.sleep(1/50.)

def create_balls(canvas):
    balls = []
    for i in range(N_BALLS):
        ball = Ball(canvas)
        balls.append(ball)
    return balls

if __name__ == '__main__':
    main()