import tkinter
import time
from graphics import Canvas
import random
from constants import *

N_BALLS = 10

def main():
    # lets make a graphics canvas!
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Bouncing Ball')
    # create the variables we need
    balls = create_balls(canvas)
    while True:
        # update world
        # recall that a ball is a dictionary!
        for ball in balls:
            # move the current ball
            # canvas.move takes three params: shape, change_x, change_y
            canvas.move(ball['oval'], ball['change_x'], ball['change_y'])

            # check for collisions for the current ball
            if hit_left_or_right_wall(canvas, ball['oval']):
                ball['change_x'] *= -1
            if hit_top_or_bottom_wall(canvas, ball['oval']):
                ball['change_y'] *= -1
        # redraw canvas
        canvas.update()
        # pause
        time.sleep(1/50.)

# return a collection of all the variables we need
def create_balls(canvas):
    # all of our bouncing balls are going to be put into this list!!
    balls = []
    for i in range(N_BALLS):
        ball = {}
        ball['change_x'] = random.randint(5, 15)
        ball['change_y'] = random.randint(5, 15)
        ball['oval'] = create_ball_oval(canvas)
        balls.append(ball)
    return balls

def create_ball_oval(canvas):
    # make a single ball. Give it random position
    x_1 = random.randint(0, CANVAS_WIDTH - BALL_SIZE)
    y_1 = random.randint(0, CANVAS_HEIGHT - BALL_SIZE)
    x_2 = x_1 + BALL_SIZE
    y_2 = y_1 + BALL_SIZE
    oval = canvas.create_oval(x_1, y_1, x_2, y_2, fill='blue', outline='blue')
    return oval

def hit_left_or_right_wall(canvas, object):
    ball_x = canvas.get_left_x(object)
    return ball_x <= 0 or ball_x > CANVAS_WIDTH - BALL_SIZE

def hit_top_or_bottom_wall(canvas, object):
    ball_y = canvas.get_top_y(object)
    return ball_y <= 0 or ball_y > CANVAS_HEIGHT - BALL_SIZE

if __name__ == '__main__':
    main()