import SimpleServer
import json

# classes are our friends!
class ChatServer:
    def __init__(self):
        self.history = []

    # this is the server request callback function.
    # our chat "client" expects us to handle two commands
    # addMsg and getMsg
    def handle_request(self, request):
        """
        A message has just arrived. From the internet! They need our help
        """
        print(request)
        cmd = request.get_command()
        params = request.get_params()
        if cmd == 'getMsgs':
            return self.get_msgs(params)
        if cmd == 'newMsg':
            return self.add_msg(params)
        return 'unknown command: ' + cmd

    def add_msg(self, params):
        user = params['user']
        msg = params['msg']
        self.history.append("[" + user + ']: ' + msg)
        return 'successful'

    def get_msgs(self, params):
        i = int(params['index'])
        to_return = self.history[i:]
        return json.dumps(to_return)

def main():
    # make the server
    handler = ChatServer()
    # start the server to handle internet requests!
    SimpleServer.run_server(handler, 8000)

if __name__ == '__main__':
    main()