"""
File: gameshow.py
------------------
Lets play a gameshow!
Now with style...
"""


def main():
    print_intro()
    door = get_valid_door()
    prize = compute_prize(door)
    print('You win: ' + str(prize) + ' treats')

def print_intro():
    """
    Simple welcome message!
    """
    print("Welcome to the CS106A Game Show")
    print("Chose a door and pick a prize")
    print("-------------")

def get_valid_door():
    """
    Get the door number from the user. Must be 1, 2 or 3
    :return: the chosen door as an integer
    """
    door = int(input("Door: "))
    # while the input is invalid
    while door < 1 or door > 3:
        # tell the user the input was invalid
        print("Invalid door!")
        # ask for a new input
        door = int(input("Door: "))
    return door

def compute_prize(door):
    """
    Compute the prize based on the door number
    :param door: which door was chosen?
    :return: the computed prize, as a number
    """
    prize = 4
    if door == 1:
        prize = 2 + 9 // 10 * 100
    elif door == 2:
        locked = prize % 2 != 0
        if not locked:
            prize += 6
    elif door == 3:
        for i in range(door):
            prize += i
    return prize

# This provided line is required at the end of a Python file
# to call the main() function.
if __name__ == '__main__':
    main()