"""
File: examplefor.py
------------------
Print the first 100 even numbers
"""
import math

MAX_SPACES = 20


def main():
    # makes an io line that goes down and right
    for i in range(MAX_SPACES):
        print_io_line(i)

    # makes an io line that goes down and left
    for i in range(MAX_SPACES):
        n_spaces = MAX_SPACES - i
        print_io_line(n_spaces)

def print_io_line(n_spaces):
    """
    Print n spaces and then print the string "io"
    :param n_spaces: how much space before io
    :return: no return!! Prints! Thats different
    """
    line = concat_n_spaces(n_spaces)
    print(line + "io")

def concat_n_spaces(n):
    """
    Generates a string with precicely n number of spaces!
    Does not print. Returns...
    :param n: how many spaces do you want?
    :return: return the string of spaces back to the caller!
    """
    result = ''
    for i in range(n):
        result += ' '
    return result


# This provided line is required at the end of a Python file
# to call the main() function.
if __name__ == '__main__':
    main()