"""
File: img_ascii.py
------------------

Converts the image to ASCII characters.
"""
from simpleimage import SimpleImage

FILENAME = 'panda.jpg'
IMG_CHARS = '▓▒░ '
BREAKPOINTS = (64, 128, 192)


def convert_img_to_ascii(img_file):
    """
    Converts an image to ASCII characters stored in IMG_CHARS based on the
    brightness breakpoints in BREAKPOINTS and prints out the resulting ascii.
    """
    pass


def main():
    convert_img_to_ascii(FILENAME)


def resize_img_for_ascii(img):
    """
    PROVIDED FUNCTION: Resize an image to account for the fact that the ASCII
    characters are taller than they are wide, so that the resulting ASCII looks
    proportionally correct.

    Arguments
    ---------
    img (simpleimage.SimpleImage) -- The image to resize.
    """
    # Stretch the width of the image by a factor of two
    width = img.width * 2.3
    height = img.height

    # Scale so the width is 150px
    scale_factor = 70 / width
    width = round(scale_factor * width)
    height = round(scale_factor * height)

    # Resize the underlying PIL image.
    img.pil_image = img.pil_image.resize((width, height))
    img.px = img.pil_image.load()
    size = img.pil_image.size
    img._width = size[0]
    img._height = size[1]


if __name__ == '__main__':
    main()