import json
import matplotlib.pyplot as plt
import sys

START_YEAR = 1800
END_YEAR = 2015
N_YEARS = END_YEAR - START_YEAR + 1


def add_country(data, line, stats_category):
    """
    This function adds one line of data to the data dictionary.
    Our data dictionary is formatted like this
    {
    "Afghanistan": {
        "life": [...],
        "pop": [...],
        "gdp": [...],
      },
      "Albania": {
        "life": [...],
        "pop": [...],
        "gdp": [...]
      },
      ...
    }

    Each line in the file is formatted like:
    Afghanistan,28.21,28.2,28.1 ...

    >>> add_country({}, 'Genovia,87,88,89,90,91', 'life')
    {'Genovia': {'life': [87.0, 88.0, 89.0, 90.0, 91.0]}}
    """
    line = line.strip()
    parts = line.split(",")
    country = parts[0]

    year_data = parts[1:]
    year_data_floats = [float(point) for point in year_data]  # converts from strings to floats

    # if we haven't seen this country,add it to the dictionary
    if country not in data:
        data[country] = {}

    # add this data entry to the dictionary
    inner_stats = data[country]
    inner_stats[stats_category] = year_data_floats

    #only necessary for doctest
    return data


def add_file(data, file_name):
    """
    The file_name is of the format <key>.csv where
    key is one of "life", "pop", "gdp"
    """

    # this gets the statistics category from the filename: life, gdp, or pop
    stats_category = file_name.split('.')[0]
    for line in open(file_name):
        add_country(line)

    # put it into a json to help out our friends :)
    output_file = open('country_data.txt', 'w')
    json.dump(data, output_file)

def load_data_from_json(file_name):
    with open(file_name) as f:
        country_data = json.load(f)
        print(min(country_data['Brazil']['life']))
        return country_data


def plot_data(data, country):
    years = [START_YEAR+i for i in range(N_YEARS)]
    life_y = data[country]['life']
    pop_y = data[country]['pop']
    gdp_y = data[country]['gdp']
    plt.figure(1)
    plt.bar(years, life_y)
    plt.title("Life Expectancy Over the Years in " + country)
    plt.ylabel("Life Expectancy")
    plt.figure(2)
    plt.bar(years, pop_y)
    plt.title("Population Over the Years in " + country)
    plt.ylabel("Population")
    plt.figure(3)
    plt.bar(years, gdp_y)
    plt.title("GDP Over the Years in " + country)
    plt.ylabel("GDP")
    plt.show()



def main():
    # print('cleaning data...')
    # data = {}
    # add_file(data, 'life.csv')
    # add_file(data, 'pop.csv')
    # add_file(data, 'gdp.csv')
    # print('Reading complete. Data structure created')
    # do something with data
    data = load_data_from_json('country_data.txt')

    args = sys.argv[1:]
    country = args[0]
    plot_data(data, country)



if __name__ == '__main__':
    main()