#!/usr/bin/env python3

"""
Stanford CS106A Waterfall warmup
"""

import sys
import tkinter
import random
import drawcanvas

from grid import Grid

SIDE = 15  # pixels across of one square (set in main() too)
WATER_FACTOR = 20  # 1 out of this factor is water in top edge
ROCK_FACTOR = 10   # 1 out of this factor is rock at the start


def down_dx(grid, x, y):
    """
    Given an in bounds x,y that has a water 'w' in it.
    Return the dx in which it should fall downwards,
    one of 0, -1, 1, None as defined in handout.
    (tests provided)
    >>> grid = Grid.build([[None, 'w', 'w', 'w', 'w', None], [None, None, 'r', 'r', 'w', None]])
    >>> down_dx(grid, 1, 0)  # try 'w' at 1,0
    0
    >>> down_dx(grid, 2, 0)  # try 'w' at 2,0
    -1
    >>> down_dx(grid, 3, 0)  # blocked (">>>" below means None result)
    >>>
    >>> down_dx(grid, 4, 0)
    1
    >>> down_dx(grid, 4, 1)  # blocked by out of bounds
    >>>
    """
    pass
    return None


def move_water(grid, x, y):
    """
    There is water at x,y.
    Compute the dx of which way down it is going
    and move it from x,y to its new square.
    Or erase it from the world if dx is None.
    """
    grid.set(x, y, None)   # Erase water's current square
    dx = down_dx(grid, x, y)
    if dx != None:
        # If we have a good dx, move water down to there
        # new x is x + dx
        # new y is y + 1 (i.e. down)
        grid.set(x + dx, y + 1, 'w')


def do_gravity(grid):
    """
    Move every water 'w' in the world
    once by calling move_water().
    """
    for y in reversed(range(grid.height)):
        for x in range(grid.width):
            if grid.get(x, y) == 'w':
                move_water(grid, x, y)
    return grid


def set_top(grid):
    """
    Set random squares at the top row, y=0, to
    have water in them.
    (provided)
    """
    for x in range(grid.width):
        if random.randrange(WATER_FACTOR) == 0:
            grid.set(x, 0, 'w')
    return grid


def init_rocks(grid):
    """
    Set a random selection of squares to be rock 'r'
    to initialize the grid.
    (provided)
    """
    for y in range(grid.height):
        for x in range(grid.width):
            if random.randrange(ROCK_FACTOR) == 0:
                grid.set(x, y, 'r')
    return grid


# ************* Utility Functions Below here


def draw_grid_canvas(grid, canvas):
    """
    Draw the movie grid to the canvas.
    """
    canvas.delete('all')
    canvas.create_rectangle(0, 0, grid.width * SIDE, grid.height * SIDE, fill='black')

    for y in range(grid.height):
        for x in range(grid.width):
            val = grid.get(x, y)
            if val:
                pixel_x = SIDE * x
                pixel_y = SIDE * y
                canvas.create_text(pixel_x, pixel_y, text=val, anchor=tkinter.NW, fill='white', font=('Courier', 24))

    canvas.update()


def do_one_round(grid, canvas):
    """Do one round of the move, call in timer."""
    set_top(grid)
    draw_grid_canvas(grid, canvas)
    do_gravity(grid)


# TK Timer fns:

def start_timer(top, delay_ms, fn):
    """Start the my_timer system, calls given fn"""
    top.after(delay_ms, lambda: my_timer(top, delay_ms, fn))


def my_timer(top, delay_ms, fn):
    """my_timer callback, re-posts itself."""
    fn()
    top.after(delay_ms, lambda: my_timer(top, delay_ms, fn))


def main():
    args = sys.argv[1:]

    width = 50
    height = 30
    grid = Grid(width, height)
    init_rocks(grid)

    canvas = drawcanvas.make_canvas(width * SIDE, height * SIDE, 'Waterfall')
    draw_grid_canvas(grid, canvas)

    start_timer(canvas, 30, lambda: do_one_round(grid, canvas))

    tkinter.mainloop()


if __name__ == '__main__':
    main()
