from grid import Grid
from drawcanvas import DrawCanvas

ARM_LENGTH = 100 # given constant for draw snowman

CELL_SIZE = 100 # given constant for visualize grid

def fancy_lines(canvas, x, y, width, height, n):
    """
    This function takes in a left, top, width, height and number of lines n.
    The function should leave a 10-pixel high margin across the top and bottom
    of the figure without any drawing. Given int n which is 2 or more, draw n lines,
    as follows: The first line should begin at the left edge, 10 pixels from the top,
    and extend to the right edge, 10 pixels from the bottom. The last line should start
    at the left edge, 10 pixels from the bottom, and extend to the right edge 10 pixels
    from the top, with the other lines distributed proportionately.
    """
    pass


def diagonal_lines(canvas, x, y, width, height, n):
    """
    This function takes in a left, top, width, height
    and number of lines n. Given int n which is 2 or more,
    draw n lines, each starting on the left edge and ending
    at the lower right corner of the figure. The first line
    should start at the upper left corner, the last line should
    start at the lower left corner, with the other lines distributed evenly.
    """
    pass


def more_lines(canvas, left, top, width, height, n):
    """
    Draw a blue rectangle at the outer edge of the figure (this code is included).
    Given int n which is 2 or more. Draw a series of lines distributed across the top
    edge of the figure, all terminating at the lower-right corner. The first line should
    start at the upper left corner, the last line should start at the upper right corner,
    with the other lines distributed evenly in between.
    """
    canvas.draw_rect(left, top, width, height, color='lightblue')
    pass


def visualize_grid(grid):
    """
    Working with data structures like Grids can get a little tricky when
    you can't visualize what you're working with!
​
    Let's code the visualize_grid(grid) function, that takes a Grid as input
    and draws the grid to the canvas.
​
    Each box in the grid should have height and width CELL_SIZE. We also want
    to print the contents of each grid cell as a string on the canvas!
​
    You can assume that the grid's contents are all strings.
    >>> grid=Grid.build([['1', '2', '3'], ['4', '5', '6'], ['7', '8', '9']])
    >>> visualize_grid(grid)
    """
    pass


def main():
    width = 900
    height = 475
    canvas = DrawCanvas(width, height)
    fancy_lines(canvas, 0, 0, width, height, 4)
    canvas.mainloop()

if __name__ == "__main__":
    main()