#!/usr/bin/env python3

"""
CS106A Intro
"""

import sys
import platform


def main():
    if "3.9" not in platform.python_version():
        print("ERROR: You are not using Python 3.9! You are using version: " + platform.python_version())
        print("Please follow the instructions on the CS106A website to download python version 3.9.1")
        return
    if len(sys.argv) != 2:
        if "darwin" in sys.platform or 'linux' in sys.platform:
            py_bin = 'python3'
        else:
            py_bin = "py"

        print(f"Hello, CS106A! Now, try running '{py_bin} intro.py <YOUR NAME HERE>' in the terminal!")
    else:
        name = " ".join(sys.argv[1:])
        print("Hello, " + name + "! You're done with the PyCharm setup process!")


# This provided line is required at the end of a Python file
# to call the main() function.
if __name__ == '__main__':
    main()
