#!/usr/bin/env python3

import sys
import tkinter
import json

CANVAS_WIDTH = 1000
CANVAS_HEIGHT = 600
TEXT_TOP_OFFSET = 10
TEXT_SIDE_OFFSET = 3

TOP_N = 10


def visualize_trends(canvas, user_tags, user_name):
    pass


def by_counts(tup):
    return tup[1]


def get_top_tags(user_tag_frequencies):
    new_tags_dict = {}
    # creates a collection of (key, value) tuples
    tags = user_tag_frequencies.items()
    tags = sorted(tags, key=by_counts, reverse=True)
    if len(tags) < TOP_N:
        return user_tag_frequencies
    tags = list(tags)[:TOP_N]
    for key, val in tags:
        new_tags_dict[key] = val

    return new_tags_dict


def make_canvas(width, height, title):
    """
    Creates and returns a drawing canvas
    of the given int size with a blue border,
    ready for drawing.
    """
    top = tkinter.Tk()
    top.minsize(width=width, height=height)
    top.title(title)
    canvas = tkinter.Canvas(top, width=width + 1, height=height + 1)
    canvas.pack()
    return canvas


def main():
    args = sys.argv[1:]

    if len(args) == 1:
        user_tags = json.load(open('tweets.json'))
        user_name = args[0]
        canvas = make_canvas(CANVAS_WIDTH, CANVAS_HEIGHT,
                             user_name + "'s hashtag trends")
        visualize_trends(canvas, user_tags, user_name)
        canvas.mainloop()
    else:
        print("Usage: python3 visualize_tweets.py username")


if __name__ == '__main__':
    main()
