#!/usr/bin/env python3
from bit import Bit
from simpleimage import SimpleImage

# Problem 1: Place Flag
def climb_mountain(bit):
    while bit.front_clear():
        bit.move()
    bit.left()
    while not bit.right_clear():
        bit.move()
    bit.right()
    while bit.front_clear():
        bit.move()
    bit.paint('red')

def climb_back_down(bit):
    bit.right()
    bit.right()
    while not bit.left_clear():
        bit.move()
    bit.left()
    while bit.front_clear():
        bit.move()
    bit.right()
    while bit.front_clear():
        bit.move()

def place_flag(filename):
    bit = Bit(filename)
    climb_mountain(bit)
    climb_back_down(bit)
    return bit

# Problem 2:
def rotate180_and_bw(filename):
    image = SimpleImage(filename)
    out = SimpleImage.blank(image.width, image.height)
    for y in range(image.height):
        for x in range(image.width):
            pixel = image.get_pixel(x, y)
            out_pixel = out.get_pixel(image.width - 1 - x,
                                      image.height - 1 - y)
            average = (pixel.red + pixel.green + pixel.blue) // 3
            out_pixel.red = average
            out_pixel.green = average
            out_pixel.blue = average
    return out

# Problem 3: Blur
def blur(filename):
    image = SimpleImage(filename)
    out = SimpleImage.blank(image.width, image.height)
    for y in range(image.height):
        for x in range(image.width):
            pixel = image.get_pixel(x, y)
            out_pixel = out.get_pixel(x, y)
            if x == 0 or x == image.width - 1:
                # just put the pixel
                out_pixel.red = pixel.red
                out_pixel.green = pixel.green
                out_pixel.blue = pixel.blue
            else:
                left_px = image.get_pixel(x - 1, y)
                right_px = image.get_pixel(x + 1, y)
                avg_red = (left_px.red + pixel.red + right_px.red) // 3
                avg_green = (left_px.green + pixel.green + right_px.green) // 3
                avg_blue = (left_px.blue + pixel.blue + right_px.blue) // 3
                out_pixel.red = avg_red
                out_pixel.green = avg_green
                out_pixel.blue = avg_blue

    return out


def main():
    choice = -1
    while choice < 1 or choice > 3:
        try:
            print('Please choose a problem to test:')
            print('1. Problem 1: Climb Mountain')
            print('2. Problem 2: Rotate and make Black and White')
            print('3. Problem 3: Blur')
            choice = int(input('Choose 1 - 3:'))
        except ValueError:
            print("Please choose between 1 and 3")

    if choice == 1:
        # Problem 1:
        for world in ['mountain1.world', 'mountain2.world']:
            bit = place_flag(world)
            print(bit)

    elif choice == 2:
        # Problem 2:
        for image_f in ['flag.png', 'tree.png', 'whippet.png']:
            out = rotate180_and_bw(image_f)
            out.show()

    else:
        # Problem 3:
        for image_f in ['flag.png', 'tree.png', 'whippet.png', 'tiny.png']:
            orig = SimpleImage(image_f)
            orig.show()
            out = blur(image_f)
            out.show()

if __name__ == '__main__':
    main()
