#!/usr/bin/env python3

"""
Stanford CS106A str1 Examples
Nick Parlante
1 function is provided, 2 left as exercises

-Demonstrate for/i/range string code
-Demonstrate using Doctests on a function
"""

import sys

def digits_only(s):
    """
    Given a string s.
    Return a string made of all
    the chars in s which are digits,
    so 'Hi4!x3' returns '43'.
    Use a for/i/range loop.
    (this code is complete)
    >>> digits_only('Hi4x3')
    '43'
    >>> digits_only('123')
    '123'
    >>> digits_only('xyz')
    ''
    >>> digits_only('')
    ''
    """
    result = ''
    for i in range(len(s)):
        if s[i].isdigit():
            result += s[i]
    return result


def str_dx(s):
    """
    Given string s.
    Returns a string where every digit is changed to 'd',
    and all other chars are changed to 'x'.
    >>> str_dx('Hi4!x3')
    'xxdxxd'
    >>> str_dx('123')
    'ddd'
    >>> str_dx('')
    ''
    """
    pass


def crazy_str(s):
    """
    Given string s. Return a string where every lowercase char
    in s is converted to uppercase, and every other char
    is converted to lowercase.
    >>> crazy_str('Hello')
    'hELLO'
    >>> crazy_str('abc2@Z')
    'ABC2@z'
    >>> crazy_str('')
    ''
    """
    pass


# Can run all Doctests in a module from the command line like this:
# python3 -m doctest str1.py
# Typically we just right-click in PyCharm to run them.
# See code below to Doctest just one function.


def main():
    args = sys.argv[1:]
    # Doctest option
    # Below is a way to put code in main() that runs the tests
    # of just one function - e.g. digits_only.
    import doctest
    # put in the name of the one function to test, then run this
    # module from the command line.
    doctest.run_docstring_examples(digits_only, globals())

# Python boilerplate.
if __name__ == '__main__':
    main()
