import sys
import matplotlib.pyplot as plt

FILENAME = 'data/next_bechdel_tests.txt'
TESTS = ['Bechdel', 'Peirce', 'Landau', 'Feldman', 'Villarreal', 'Hagen', 'Ko', 'Villalobos', 'Waithe', 'Koeze-Dottle',
         'Uphold', 'White', 'Rees-Davies']


def read_file(filename):
    """
    Reads the information from the specified file and builds a new
    movie_data dictionary with the data found in the file. Returns the
    newly created dictionary.
     >>> read_file('data/small_tests.txt')
     {'Test Movie': [0, 0, 0, 1], 'Test Film': [1, 0, 1, 0]}
    """
    pass


def plot_test(movie_data, test_name):
    """
    Totals the number of movies that passed and failed for a given test,
    and the plots the data using matplotlib.
    """
    test_index = TESTS.index(test_name)
    num_passed = 0
    num_failed = 0

    # your code here to count the number of movies that pass and fail this test

    # your code here to plot the data

    plt.ylabel('Number of Movies')
    plt.title(test_name + ' Test Plots')

    plt.ylim([0, 50])
    plt.show()


def main():
    # no need to edit main
    args = sys.argv[1:]
    movie_data = read_file(FILENAME)
    if args[0] == '-dict':
        print(movie_data)
    if args[0] == '-test':
        plot_test(movie_data, args[1])


if __name__ == '__main__':
    main()