import tkinter
from drawcanvas import DrawCanvas


def draw_ray_patch(canvas, left, top, width, height, num_rays):
    '''
    Implement draw_ray_patch, a function that draws a patch of
    size (width, height) on the canvas, starting at (left, top).
    The patch should contain num_rays lines stretching from the
    bottom right to the top of the patch, evenly spaced across
    the top of the patch.
    '''
    for i in range(num_rays):
        # determine how far over in the x-direction the line should be drawn
        x_add = i / (num_rays - 1) * (width - 1)

        # draw line from top to bottom right
        canvas.draw_line(left + x_add, top, left + width - 1, top + height - 1)


def draw_stripe_patch(canvas, left, top, width, height, num_stripes):
    """
    Implement draw_stripe_patch, a function that draws a patch of
    size (width, height) on the canvas, starting at (left, top).
    The patch should contain num_stripes rectangles that are the
    width of the patch, and have a height that allows for
    num_stripes rectangles of equal size on the patch.
    """
    stripe_thickness = height // num_stripes

    # draw the stripes
    for i in range(num_stripes):
        # calculate the y coordinate for the top of the current stripe
        curr_y = top + i * stripe_thickness

        if i % 2 == 0:  # draw red on the even indices of the loop
            canvas.fill_rect(left, curr_y, width, stripe_thickness, color="red")
        else:  # draw green on the odd indices of the loop
            canvas.fill_rect(left, curr_y, width, stripe_thickness, color="green")


def draw_flag(canvas, width, height, num_rays, num_stripes):
    """
    Create a flag with three patches horizontally across the
    canvas: a stripe patch on the left, a ray patch in the
    middle, and a stripe patch on the right.

    The canvas dimensions are (width, height), and the patches
    should have num_rays or num_stripes accordingly.
    """
    # draw white background of flag
    canvas.fill_rect(0, 0, width, height, color="white")

    # calculate reference points for patches
    patch_width = width // 3

    draw_stripe_patch(canvas, 0, 0, patch_width, height, num_stripes)
    draw_ray_patch(canvas, patch_width, 0, patch_width, height, num_rays)
    draw_stripe_patch(canvas, 2 * patch_width, 0, patch_width, height, num_stripes)


def main():
    # These test the draw_flag function
    width = 900
    height = 500
    num_stripes = 9
    num_rays = 4
    canvas = DrawCanvas(width, height)
    draw_flag(canvas, width, height, num_rays, num_stripes)
    tkinter.mainloop()


if __name__ == "__main__":
    main()