#!/usr/bin/env python3

"""
Stanford Bluescreen Example

$ python3 bluescreen.py monkey-500.jpg moon-600.jpg
$ python3 bluescreen.py monkey-500.jpg stanford-600.jpg

"""

import sys
from simpleimage import SimpleImage


def do_bluescreen(front_filename, back_filename):
    """
    Front strategy: loop over front image,
    detect blue pixels there,
    substitute in pixels from back.
    Return changed front image.
    """
    # Front image has special color in back
    front = SimpleImage(front_filename)
    # Back image is special background
    back = SimpleImage(back_filename)

    # Pseudo-code
    # Loop through front image
        # if front pixel is "superblue"
        # replace with back pixel
    # return front image


def main():
    args = sys.argv[1:]
    if len(args) == 2:
        image = do_bluescreen(args[0], args[1])
        image.show()


if __name__ == '__main__':
    main()
