#!/usr/bin/env python3

"""
Program to "RBG-ify" an image - take every pixel and set it to be
red, green, or blue based on the most dominant (highest) RBG value
in the pixel.

Example to run:
python rgb-ify.py poppy-300.jpg

In general to run:
python rgb-ify.py [image_file].jpg

Written by Frankie Cerkvenik 2023
"""

import sys
from simpleimage import SimpleImage

def get_red(pixel):
    """
    Given an RGB pixel, return the "red" value that it should have in the
    RGB problem. That is, if the R value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """

def get_blue(pixel):
    """
    Given an RGB pixel, return the "blue" value that it should have in the
    RGB problem. That is, if the B value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """

def get_green(pixel):
    """
    Given an RGB pixel, return the "green" value that it should have in the
    RGB problem. That is, if the G value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """

def change_red(any_pixel):
    """
    Given an RGB pixel, return the "red" value that it should have in the
    RGB problem. That is, if the R value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """

def change_green(any_pixel):
    """
    Given an RGB pixel, return the "green" value that it should have in the
    RGB problem. That is, if the G value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """


def change_blue(any_pixel):
    """
    Given an RGB pixel, return the "blue" value that it should have in the
    RGB problem. That is, if the B value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """

def rgb_ify(filename):
    """
    Given the filename of an image, create and return another image where each pixel
    in the returned image is red, green or blue depending on the most dominant color
    in the original image. If it is a tie, leave the pixel its original color.
    """

def main():
    args = sys.argv[1:]

    # args:
    # image filename

    if len(args) == 1:
        image = rgb_ify(args[0])
        image.show()
    else:
        print("Please run with one filename like 'python rgb-ify.py stanford-600.jpg")



if __name__ == '__main__':
    main()
