#!/usr/bin/env python3

"""
SOLUTION CODE Program to "RBG-ify" an image - take every pixel and set it to be
red, green, or blue based on the most dominant (highest) RBG value
in the pixel.

Example to run:
python rgb-ify_soln.py poppy-300.jpg

In general to run:
python rgb-ify_soln.py [image_file].jpg
"""

import sys
from simpleimage import SimpleImage

def get_red(any_pixel):
    """
    Given an RGB pixel, return the "red" value that it should have in the
    RGB problem. That is, if the R value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """
    if any_pixel.red > any_pixel.green and any_pixel.red > any_pixel.blue:
        return 255
    else:
        return 0

def get_green(any_pixel):
    """
    Given an RGB pixel, return the "green" value that it should have in the
    RGB problem. That is, if the G value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """
    if any_pixel.green > any_pixel.red and any_pixel.green > any_pixel.blue:
        return 255
    else:
        return 0

def get_blue(any_pixel):
    """
    Given an RGB pixel, return the "blue" value that it should have in the
    RGB problem. That is, if the B value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """
    if any_pixel.blue > any_pixel.green and any_pixel.blue > any_pixel.red:
        return 255
    else:
        return 0


def change_red(any_pixel):
    """
    Given an RGB pixel, return the "red" value that it should have in the
    RGB problem. That is, if the R value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """
    if any_pixel.red > any_pixel.green and any_pixel.red > any_pixel.blue:
        any_pixel.red = 255
    else:
        any_pixel.red = 0

def change_green(any_pixel):
    """
    Given an RGB pixel, return the "green" value that it should have in the
    RGB problem. That is, if the G value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """
    if any_pixel.green > any_pixel.red and any_pixel.green > any_pixel.blue:
        any_pixel.green = 255
    else:
        any_pixel.green = 0


def change_blue(any_pixel):
    """
    Given an RGB pixel, return the "blue" value that it should have in the
    RGB problem. That is, if the B value is the greatest value in the pixel's
    RGB representation, return 255, otherwise return 0
    """
    if any_pixel.blue > any_pixel.green and any_pixel.blue > any_pixel.red:
        any_pixel.blue = 255
    else:
        any_pixel.blue = 0
def rgb_ify(filename):
    """
    Given the filename of an image, create and return another image where each pixel
    in the returned image is red, green or blue depending on the most dominant color
    in the original image. If it is a tie, leave the pixel its original color.
    """
    image = SimpleImage(filename)
    # looping over rows, but could loop over columns
    for y in range(image.height):
        for x in range(image.width):
            # current pixel
            pixel = image.get_pixel(x, y)
            # Using the decomposed functions with returns
            pixel.red = get_red(pixel) # will be either 255 or 0
            pixel.green = get_green(pixel) # will be either 255 or 0
            pixel.blue = get_blue(pixel) # will be either 255 or 0

            # Using the decomposed functions without returns
            # change_red(pixel)  # will be either 255 or 0
            # change_green(pixel)  # will be either 255 or 0
            # change_blue(pixel)  # will be either 255 or 0

            # not using the decomposed functions suggested
            # (comment out previous 3 lines and uncomment below)
            # if pixel.red > pixel.green and pixel.red > pixel.blue:
            #     pixel.red = 255
            #     pixel.green = 0
            #     pixel.blue = 0
            # if pixel.green > pixel.red and pixel.green > pixel.blue:
            #     pixel.red = 0
            #     pixel.green = 255
            #     pixel.blue = 0
            # if pixel.blue > pixel.green and pixel.blue > pixel.red:
            #     pixel.red = 0
            #     pixel.green = 255
            #     pixel.blue = 0
    return image

def main():
    args = sys.argv[1:]

    # args:
    # front-image back-image         - do front strategy
    # front-image shift-x back-image - do back strategy
    if len(args) == 1:
        image = rgb_ify(args[0])
        image.show()
    else:
        print("Please run with one filename like 'python rgb-ify_soln.py stanford-600.jpg")



if __name__ == '__main__':
    main()
