#!/usr/bin/env python3

"""
Program that takes in two numbers as command-line input, computes
and prints the factorials of these numbers, then computes and
prints the average of these factorials

Example usage:

python3 factorial_average.py 2 3
Output:
The factorial of num1 is:
2
The factorial of num2 is:
6
The average of these is:
4.0

Written by Frankie Cerkvenik 2023
"""

import sys


def factorial(num):
    """
    Given num, computes and returns its factorial.
    Recall the definition of a factorial:
    3! = 3 * 2 * 1
    Additionally,
    0! = 1
    >>> factorial(3)
    6
    >>> factorial(1)
    1
    >>> factorial(0)
    1
    """
    result = 1
    # FOUND BUG: range was starting at 0, not 1, zeroing everything out
    for i in range(1, num + 1):
        result = result * i
    return result


def compute_average(num1, num2):
    """
    Given two numbers, computes and returns their average
    >>> compute_average(1, 2)
    1.5
    >>> compute_average(0, 0)
    0.0
    >>> compute_average(12, 20)
    16.0
    """
    #NO BUG- ISSUE MUST BE IN FACTORIAL_AVERAGE
    return (num1 + num2) / 2


def factorial_average(num1, num2):
    """
    Given two numbers, computes and prints their factorials,
    then computes and prints the average of these factorials
    """
    factorial_1 = factorial(num1)
    factorial_2 = factorial(num2)
    print("The factorial of num1 is:")
    print(factorial_1)
    print("The factorial of num2 is:")
    print(factorial_2)

    # FOUND BUG: WAS PASSING IN FACTORIAL_1 TWICE!
    average = compute_average(factorial_1, factorial_2)
    print("The average of these is:")
    print(average)


def main():
    args = sys.argv[1:]

    # args:
    # num1 num2

    if len(args) == 2:
        factorial_average(int(args[0]), int(args[1]))
    else:
        print("Please run with two numbers, like 'python3 factorial_average.py 7 3'")



if __name__ == '__main__':
    main()
