"""
Program to display a square checkerboard with any number of rows

Written by Frankie Cerkvenik based on examples by Chris Piech and Mehran Sahami 2023
"""
from graphics import Canvas
import sys

SQUARE_WIDTH = 20

def draw_checkerboard(canvas, rows):
    # for each row
    for x in range(rows):
        # draw one row
        for y in range(rows):
            # if we are on an "even" square, make a black square
            if (x + y) % 2 == 0:
                rect = canvas.create_rectangle(x * SQUARE_WIDTH, y * SQUARE_WIDTH, (x + 1) * SQUARE_WIDTH, (y + 1) * SQUARE_WIDTH, 'black')
            else:
                # otherwise we are on an "odd" square, make a white square
                rect = canvas.create_rectangle(x * SQUARE_WIDTH, y * SQUARE_WIDTH, (x + 1) * SQUARE_WIDTH,
                                               (y + 1) * SQUARE_WIDTH, 'white')
            canvas.set_outline_color(rect, 'black')
def main():
    #you can ignore this :)
    args = sys.argv[1:]
    if len(args) != 1:
        print("Please run with a number, like `python3 diagonal.py 3`")
        return
    rows = int(args[0])
    # YOUR CODE HERE, note you can use the rows variable, and it represents the number of rows
    # to make your diagonal line
    canvas = Canvas(SQUARE_WIDTH*(rows + 1), SQUARE_WIDTH*(rows + 1), 'Diagonal')

    # call your helper function here!
    draw_checkerboard(canvas, rows)
    canvas.mainloop()

if __name__ == '__main__':
    main()
