"""
Program to display a diagonal line of squares for any number of rows

Written by Frankie Cerkvenik based on examples by Chris Piech and Mehran Sahami 2023
"""
from graphics import Canvas
import sys

SQUARE_WIDTH = 20

def diagonal(canvas, rows):
    # for every row, draw a single square
    for i in range(rows):
        # The upper left coordinate for the square should be on the i'th row and i'th column
        # where each row and column are SQUARE_WIDTH pixels, hence multiplying

        # The lower right coordinate should be at the stat of the next row and column
        # hence adding 1 to i and then doing the same multiplication
        canvas.create_rectangle(i * SQUARE_WIDTH, i * SQUARE_WIDTH, (i + 1) * SQUARE_WIDTH, (i + 1) * SQUARE_WIDTH, 'blue')

def main():
    #you can ignore this :)
    args = sys.argv[1:]
    if len(args) != 1:
        print("Please run with a number, like `python3 diagonal.py 3`")
        return
    rows = int(args[0])
    # YOUR CODE HERE, note you can use the rows variable, and it represents the number of rows
    # to make your diagonal line
    canvas = Canvas(SQUARE_WIDTH*(rows + 1), SQUARE_WIDTH*(rows + 1), 'Diagonal')

    # call your helper function here!
    diagonal(canvas, rows)
    canvas.mainloop()

if __name__ == '__main__':
    main()
