#!/usr/bin/env python3

"""
Program that takes in any amount of numbers as command-line input, computes
and prints the factorials of these numbers, then computes and
prints the average of these factorials

Example usage:

python3 factorial_average.py 2 3 1
Output:
The factorials of each number are: [2, 6, 1]
The average of these factorials is: 3.0

Written by Frankie Cerkvenik 2023
"""

import sys

def factorial(num):
    """
    Given num, computes and returns its factorial.
    Recall the definition of a factorial:
    3! = 3 * 2 * 1
    Additionally,
    0! = 1
    >>> factorial(3)
    6
    >>> factorial(0)
    1
    >>> factorial(1)
    1
    """
    result = 1
    for i in range(1, num + 1):
        result = result * i
    return result

def change_list_to_factorials(num_list):
    """
    Given a list of numbers, changes each number in the list to be its factorial
    NOTE: change_list_to_factorials has no return, so doctesting is a little more involved
    >>> l = [1, 2, 3]
    >>> change_list_to_factorials(l)
    >>> print(l) # need to "output" l in some way to see if it changed
    [1, 2, 6]
    """
    pass
def compute_list_factorials(num_list):
    """
    Given a list of numbers, computes and returns a list of each numbers' factorial
    >>> compute_list_factorials([1, 2, 3])
    [1, 2, 6]
    """
    result = []
    for elem in num_list:
        fact = factorial(elem)
        result.append(fact)
    return result

def compute_list_average(num_list):
    """
    Given a list of numbers, computes and returns the average of the list
    >>> compute_list_average([4, 3, 5])
    4.0
    >>> compute_list_average([])
    0.0
    """
    s = 0
    for elem in num_list:
        s += elem
    return s / len(num_list)


def list_factorial_average(num_list):
    """
    Given a list of numbers, computes and prints their factorials as a list,
    then computes and prints the average of these factorials
    """
    # First, get list of factorials
    # Next, calculate average
    # Print both pieces of information!
    factorials = compute_list_factorials(num_list)
    print("The factorials are:")
    print(factorials)
    average = compute_list_average(factorials)
    print("The average of these numbers are:")
    print(average)
def main():
    args = sys.argv[1:]

    # args:
    # num1, num2, num3....

    if len(args) >= 1:
        nums = [int(i) for i in args]
        list_factorial_average(nums)
    else:
        print("Please run with at least one number, like 'python3 factorial_average.py 7 3 4 8...'")



if __name__ == '__main__':
    main()
