#!/usr/bin/env python3

"""
Program that takes in two lists of numbers
as command line input and outputs a list with the largest
number in each index in the two lists. If one list is shorter
than the other, takes the remaining numbers from the longer list

Example usage:

python3 factorial_average.py -l1 2 3 1 -l2 1 3 2
Output:
Original Lists:
[2, 3, 1, 4]
[1, 3, 2]
Result list:
[2, 3, 2, 4]

Written by Frankie Cerkvenik 2023
"""

import sys


def main():
    args = sys.argv[1:]
    nums_1 = []
    nums_2 = []
    if len(args) >= 1:
        if args[0] != '-l1':
            print("Please run like so 'python3 factorial_average.py -l1 10 12 13 -l2 7 3 4'")
            return
        else:
            i = 1
            while args[i] != '-l2' and i < len(args):
                nums_1.append(int(args[i]))
                i += 1
            if args[i] != '-l2':
                print("Please run like so 'python3 factorial_average.py -l1 10 12 13 -l2 7 3 4'")
                return
            else:
                nums_2 = [int(x) for x in args[i+1:]]
    else:
        print("Please run like so 'python3 factorial_average.py -l1 10 12 13 -l2 7 3 4'")
        return

    # ignore code above, use nums_1 and nums_2
    print("Original lists:")
    print(nums_1)
    print(nums_2)





if __name__ == '__main__':
    main()
