"""
Program to display a square and some circles, moving the square into the circles removes them
from the canvas

Written by Frankie Cerkvenik 2023
"""
import random
import time

from graphics import Canvas

CANVAS_WIDTH = 600
CANVAS_HEIGHT = 600
SQUARE_SIZE = 80
DELAY = 1/120
CIRCLE_MIN_SIZE = 20
CIRCLE_MAX_SIZE = 80


def make_circles(canvas):
    """
    Makes and returns a list of 10 circle objects on the parameter canvas
    """
    # make 10 randomly placed circles
    circles = []  # important to remember all our circle objects
    for i in range(10):
        x = random.randint(0, CANVAS_WIDTH)
        y = random.randint(0, CANVAS_HEIGHT)
        size = random.randint(CIRCLE_MIN_SIZE, CIRCLE_MAX_SIZE)
        circle = canvas.create_oval(x, y, x + size, y + size, "blue")
        circles.append(circle)

    return circles


def remove_touched_circles(canvas, circles, square_x, square_y):
    """
    Finds all circles that are overlapping with the square at square_x, square_y
    and removes them from the canvas and the circles list
    """
    hits = canvas.find_overlapping(square_x, square_y, square_x + SQUARE_SIZE, square_y + SQUARE_SIZE)
    for elem in hits:
        # Careful: our square will also be in the hits list
        if elem in circles:  # make sure not to delete our square!
            canvas.delete(elem)
            # remove from the circles list too so we know when we're done!
            circles.remove(elem)

def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Move Square')

    start_y = CANVAS_HEIGHT / 2 - SQUARE_SIZE / 2
    end_y = start_y + SQUARE_SIZE
    rect = canvas.create_rectangle(0, start_y, SQUARE_SIZE, end_y, 'black')

    circles = make_circles(canvas)

    while len(circles) != 0:
        # get mouse position
        x = canvas.get_mouse_x()
        y = canvas.get_mouse_y()

        #use move_to not move because we have a position not an offset
        canvas.move_to(rect, x, y)

        remove_touched_circles(canvas, circles, x, y)

        canvas.update()
        time.sleep(DELAY)

    print("Winner!")
    canvas.mainloop()

if __name__ == '__main__':
    main()
