"""
Program to display a dvd logo bouncing around a screen like in the good old days

Written by Frankie Cerkvenik 2023
"""
import time
import random
import math

from graphics import Canvas

CANVAS_WIDTH = 1200
CANVAS_HEIGHT = 800
LOGO_HEIGHT = 120
LOGO_WIDTH = 240
DELAY = 1/120
DVD_IMGS = [
    'img/dvd_blue.png',
    'img/dvd_dgreen.png',
    'img/dvd_green.png',
    'img/dvd_lpink.png',
    'img/dvd_orange.png',
    'img/dvd_pink.png',
    'img/dvd_purple.png',
    'img/dvd_red.png',
    'img/dvd_teal.png',
    'img/dvd_yellow.png'
]
NUM_DVDS = 10


def change_dvd_pic(canvas, dvd_index, dvd, left_x, top_y):
    """
    Delete the old dvd logo on the canvas and make + return a new one of a new
    color. Make the dvd logo from the dvd_index'th item in DVD_IMGS
    :param canvas: The canvas where the dvd logo is
    :param dvd_index: The index of the new dvd logo in DVD_IMGS
    :param dvd: the dvd logo object to be deleted
    :param left_x: the x coordinate of the dvd logo
    :param top_y: the y coordinate of the dvd logo
    :return: the new dvd object that we make
    """
    canvas.delete(dvd)
    dvd = canvas.create_image_with_size(left_x, top_y, LOGO_WIDTH, LOGO_HEIGHT, DVD_IMGS[dvd_index])
    return dvd


def calculate_complement(new_change, old_change):
    """
    new_change: The new value of change_x or change_y
    old_change: The old value of the other change variable
    return: The new value of the other change variable
    """
    s = old_change / abs(old_change)
    if abs(new_change) == 1:
        new_complement = s * 2
    else:
        new_complement = s * 1
    return new_complement


def sign(num):
    """
    Returns the sign of num
    """
    return num / abs(num)


def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'DVD')
    # start on the left edge near the middle, but randomly offset
    start_y = CANVAS_HEIGHT / 2 - LOGO_HEIGHT / 2 + random.randint(-1 * CANVAS_HEIGHT / 4, CANVAS_HEIGHT / 4)
    # end_y = start_y + LOGO_HEIGHT
    dvd_index = 0 # variable to which dvd logo to use next
    dvd = canvas.create_image_with_size(0, start_y, LOGO_WIDTH, LOGO_HEIGHT, DVD_IMGS[dvd_index])
    change_x = 1
    change_y = 2

    while True:
        canvas.move(dvd, change_x, change_y)
        # the current coordinates of the dvd object
        top_y = canvas.get_top_y(dvd)
        bottom_y = top_y + LOGO_HEIGHT
        left_x = canvas.get_left_x(dvd)
        right_x = left_x + LOGO_WIDTH
        if top_y <= 0 or bottom_y >= CANVAS_HEIGHT:
            # hit the top
            sign_y = sign(change_y)
            change_y = -1 * sign_y * random.randint(1, 2)
            change_x = calculate_complement(change_y, change_x)

            # little trick to keep dvd_index between 0 and 10
            dvd_index = (dvd_index + 1) % NUM_DVDS
            dvd = change_dvd_pic(canvas, dvd_index, dvd, left_x, top_y)

            canvas.move(dvd, change_x, change_y) # avoid sticky wall bug
        elif left_x <= 0 or right_x >= CANVAS_WIDTH:
            # hit the left
            sign_x = sign(change_x)
            change_x = sign_x * -1 * random.randint(1, 2)
            change_y = calculate_complement(change_x, change_y)

            # little trick to keep dvd_index between 0 and 10
            dvd_index = (dvd_index + 1) % NUM_DVDS
            dvd = change_dvd_pic(canvas, dvd_index, dvd, left_x, top_y)

            canvas.move(dvd, change_x, change_y) # avoid sticky wall bug
        canvas.update()
        time.sleep(DELAY)

if __name__ == '__main__':
    main()
