"""
Program to display frequency with which certain values appear within a column of given spreadsheet

Example:
    python3 data_processing.py staff_.csv 3 CS EE SymSys

    Would display a bar chart with the number of people on staff with concentrations in CS, EE and SymSys
    Note: column 3 (not zero-indexed) in the staff_info file is the "concentration" column
    Note: a column might have multiple values, (like column 3 in the last row of staff.csv),
    just test to see if a given value is IN the column, not EQUAL TO column.
"""

import sys

from graphics import Canvas

CANVAS_WIDTH = 1450
CANVAS_HEIGHT = 500

BORDER = 40

def make_bar_chart(canvas, x_labels, bar_heights, y_min, y_max):
    """
    Creates a bar chart on parameter canvas with categories for each item in
    x_labels, bars of heights specified by bar_heights and a y axis
    from y_min to y_max
    """
    # make axes
    canvas.create_line(BORDER, BORDER, BORDER, CANVAS_HEIGHT - BORDER)
    canvas.create_line(BORDER, CANVAS_HEIGHT - BORDER, CANVAS_WIDTH - BORDER, CANVAS_HEIGHT - BORDER)

    # make y-labels
    canvas.create_text(0, CANVAS_HEIGHT - BORDER, str(y_min), anchor='w', font='Courier 24')
    canvas.create_text(0, BORDER, str(y_max), anchor='w', font='Courier 24')

    # make x-labels
    bucket_width = (CANVAS_WIDTH - 2*BORDER) // len(x_labels)
    bucket_margin = bucket_width // 4
    for i in range(len(x_labels)):
        canvas.create_text(BORDER + i*bucket_width, CANVAS_HEIGHT - BORDER, x_labels[i], anchor='nw', font='Courier 24')

    # make bars
    for i in range(len(bar_heights)):
        height = (bar_heights[i] / (y_max - y_min)) * (CANVAS_HEIGHT - 2 * BORDER)
        rect = canvas.create_rectangle(BORDER + i*bucket_width, CANVAS_HEIGHT - BORDER - height, BORDER + (i + 1)*bucket_width - bucket_margin, CANVAS_HEIGHT - BORDER, 'pink')
        canvas.create_text(BORDER + i*bucket_width + bucket_margin, CANVAS_HEIGHT - BORDER - height - BORDER / 2, str(bar_heights[i]), anchor='nw', font='Courier 24')
        canvas.set_outline_color(rect, 'black')

def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, "Data Science!")

    # demo bar chart function - replace code below
    # see staff_info.csv for explanation of values
    # format of args: filename col_num(not zero indexed) y_min y_max x_label x_label x_label ...
    # this would give the display the expected output of
    # python3 data_processing.py test_file.csv 2 0 5 BS MS PHD
    # note we have hardcoded all values instead of processing the arguments or reading the file

    x_labels = ["BS", "MS", "PHD"]
    bar_values = [3, 2, 1]
    make_bar_chart(canvas, x_labels, bar_values, 0, 5)

    # 1. proccess command line arguments
    # 2. get bar heights
    # 3. call make_bar_chart


    # leave this in!
    canvas.mainloop()

if __name__ == '__main__':
    main()