"""
A series of string exercises to get the juices flowing! Run doctests to test

Written by Frankie Cerkvenik, borrowing some problems from Nick Parlante
"""


def is_catty(s):
    """
    Returns True if s contains the word 'cat', case-insensitive
    False otherwise
    Doctests:
    >>> is_catty('cat')
    True
    >>> is_catty('Cat')
    True
    >>> is_catty('cAT')
    True
    >>> is_catty('dog')
    False
    >>> is_catty('dog cat')
    True
    """
    pass


def take_out_vowels(s):
    """
    Makes and returns a string with every letter in s
    except the vowels (aeiou)
    Doctests:
    >>> take_out_vowels('greece')
    'grc'
    >>> take_out_vowels('Annapolis')
    'nnpls'
    >>> take_out_vowels('aeiouAEIOU')
    ''
    >>> take_out_vowels('CS')
    'CS'
    """
    pass


def construct(s):
    """
    Separate all the digits and alphabetical characters
    in s into two separate strings, then return the concatenaiton
    of the alphabetical characters and the digits. Discard other characters.
    Doctests:
    >>> construct("CS106A is tough :/")
    'CSAistough106'
    >>> construct("CS106A and CS106B are fun!")
    'CSAandCSBarefun106106'
    >>> construct('cat')
    'cat'
    >>> construct('8ar8ie')
    'arie88'
    """
    pass


def extract_sum(s):
    """
    return the sum of all the numbers in s
    Doctests:
    >>> extract_sum('106')
    7
    >>> extract_sum('CS106A')
    7
    >>> extract_sum('Barbie')
    0
    >>> extract_sum('pi is 3.14')
    8
    >>> extract_sum('')
    0
    """
    pass


def get_sandwiched_letters(s, delim):
    """
    Returns the letters in between the first occurrence of delim and the
    second occurrence of delim in s. If delim does not appear twice,
    return the empty string
    >>> get_sandwiched_letters('banana', 'a')
    'n'
    >>> get_sandwiched_letters('banana', 'A')
    ''
    >>> get_sandwiched_letters('soak up the sun', ' ')
    'up'
    >>> get_sandwiched_letters('soak up the sun', 's')
    'oak up the '
    >>> get_sandwiched_letters('hello world!', '!')
    ''
    """
    pass


def switch_letters(s, letter1, letter2):
    """
    for every letter in s, if it equal to letter1, make it letter2
    and vice versa. This is case-insensitive.
    Return the result, all uppercase. See doctests for examples
    >>> switch_letters('cat', 't', 'C')
    'TAC'
    >>> switch_letters('Barbie', 'A', 'b')
    'ABRAIE'
    >>> switch_letters('dog', 'o', 'i')
    'DIG'
    >>> switch_letters('heLLo world!', 'l', 'p')
    'HEPPO WORPD!'
    """
    pass


def get_same_letters(str1, str2):
    """
    return a string made up only of letters that appear
    in the same index in both str1 and str2, case insensitive.
    Return all lowercase letters
    See Doctests for examples
    >>> get_same_letters('Greece', 'greek')
    'gree'
    >>> get_same_letters('apple', 'banana')
    ''
    >>> get_same_letters('abc', 'zBa')
    'b'
    >>> get_same_letters('frankie', 'Frankenstein')
    'frank'
    """
    # hint: loop through the shorter string only
    pass

def get_a_indexes(s):
    """
    return a list of all the indexes of a or A in s
    See Doctests for examples
    >>> get_a_indexes('AaA')
    [0, 1, 2]
    >>> get_a_indexes('bat')
    [1]
    >>> get_a_indexes('Annapolis')
    [0, 3]
    >>> get_a_indexes('Greece')
    []
    """
    pass


def reverse_words(s):
    """
    Reverse each word in s, but not the entire string. A word
    is separated by spaces. See Doctests for examples
    >>> reverse_words('cat dog')
    'tac god'
    >>> reverse_words('cat-dog')
    'god-tac'
    >>> reverse_words('frankie')
    'eiknarf'
    >>> reverse_words('cs106a is a tough class')
    'a601sc si a hguot ssalc'
    """
    # hint: use split!
    pass


def get_num_list(s):
    """
    returns a list of ints, where each int is a number from s
    Define a "number" in s as any number of digits that aren't
    separated by a non-digit. See Doctests for examples
    Doctests:
    >>> get_num_list('106A106B 11 12')
    [106, 106, 11, 12]
    >>> get_num_list('106A106B1112')
    [106, 106, 1112]
    >>> get_num_list('barbie')
    []
    >>> get_num_list('CS106A')
    [106]
    """
    # buckle up, this one is pretty wild
    # Think of this as looping through all chunks,
    # where a chunk is one number (any number of digits)
    # OR it is one letter (one digit). Note you will need an inner loop
    # that loops over the characters in a chunk, and an outer loop
    # that loops over chunks
    pass
