"""
A series of string exercises to get the juices flowing! Run doctests to test

Written by Frankie Cerkvenik, borrowing some problems from Nick Parlante
"""


def is_catty(s):
    """
    Returns True if s contains the word 'cat', case-insensitive
    False otherwise
    Doctests:
    >>> is_catty('cat')
    True
    >>> is_catty('Cat')
    True
    >>> is_catty('cAT')
    True
    >>> is_catty('dog')
    False
    >>> is_catty('dog cat')
    True
    """
    # trick: search in a lowercase version of the string
    all_lower = s.lower()
    return 'cat' in all_lower


def take_out_vowels(s):
    """
    Makes and returns a string with every letter in s
    except the vowels (aeiou)
    Doctests:
    >>> take_out_vowels('greece')
    'grc'
    >>> take_out_vowels('Annapolis')
    'nnpls'
    >>> take_out_vowels('aeiouAEIOU')
    ''
    >>> take_out_vowels('CS')
    'CS'
    """
    vowels = 'aeiouAEIOU'
    result = ''
    for letter in s:
        if letter not in vowels:
            result += letter
    return result


def construct(s):
    """
    Separate all the digits and alphabetical characters
    in s into two separate strings, then return the concatenaiton
    of the alphabetical characters and the digits. Discard other characters.
    Doctests:
    >>> construct("CS106A is tough :/")
    'CSAistough106'
    >>> construct("CS106A and CS106B are fun!")
    'CSAandCSBarefun106106'
    >>> construct('cat')
    'cat'
    >>> construct('8ar8ie')
    'arie88'
    """
    letters = ''
    nums = ''
    for letter in s:
        if letter.isdigit():
            nums += letter
        if letter.isalpha():
            letters += letter
    return letters + nums


def extract_sum(s):
    """
    return the sum of all the numbers in s
    Doctests:
    >>> extract_sum('106')
    7
    >>> extract_sum('CS106A')
    7
    >>> extract_sum('Barbie')
    0
    >>> extract_sum('pi is 3.14')
    8
    >>> extract_sum('')
    0
    """
    total = 0
    for letter in s:
        if letter.isdigit():
            total += int(letter)
    return total


def get_sandwiched_letters(s, delim):
    """
    Returns the letters in between the first occurrence of delim and the
    second occurrence of delim in s. If delim does not appear twice,
    return the empty string
    >>> get_sandwiched_letters('banana', 'a')
    'n'
    >>> get_sandwiched_letters('banana', 'A')
    ''
    >>> get_sandwiched_letters('soak up the sun', ' ')
    'up'
    >>> get_sandwiched_letters('soak up the sun', 's')
    'oak up the '
    >>> get_sandwiched_letters('hello world!', '!')
    ''
    """
    first_index = s.find(delim)
    if first_index == -1:
        return ''
    s = s[first_index + 1:]
    second_index = s.find(delim)
    if second_index == -1:
        return ''
    return s[:second_index]


def switch_letters(s, letter1, letter2):
    """
    for every letter in s, if it equal to letter1, make it letter2
    and vice versa. This is case-insensitive.
    Return the result, all uppercase. See doctests for examples
    >>> switch_letters('cat', 't', 'C')
    'TAC'
    >>> switch_letters('Barbie', 'A', 'b')
    'ABRAIE'
    >>> switch_letters('dog', 'o', 'i')
    'DIG'
    >>> switch_letters('heLLo world!', 'l', 'p')
    'HEPPO WORPD!'
    """
    result = ''
    for letter in s.upper():
        if letter == letter1.upper():
            result += letter2.upper()
        elif letter == letter2.upper():
            result += letter1.upper()
        else:
            result += letter
    return result


def get_same_letters(str1, str2):
    """
    return a string made up only of letters that appear
    in the same index in both str1 and str2, case insensitive.
    Return all lowercase letters
    See Doctests for examples
    >>> get_same_letters('Greece', 'greek')
    'gree'
    >>> get_same_letters('apple', 'banana')
    ''
    >>> get_same_letters('abc', 'zBa')
    'b'
    >>> get_same_letters('frankie', 'Frankenstein')
    'frank'
    """
    # hint: loop through the shorter string only
    shorter = str1
    if len(str2) < len(str1):
        shorter = str2
    str1 = str1.lower()
    str2 = str2.lower()
    # need for i in range here
    result = ''
    for i in range(len(shorter)):
        if str1[i] == str2[i]:
            result += str1[i]
    return result

def get_a_indexes(s):
    """
    return a list of all the indexes of a or A in s
    See Doctests for examples
    >>> get_a_indexes('AaA')
    [0, 1, 2]
    >>> get_a_indexes('bat')
    [1]
    >>> get_a_indexes('Annapolis')
    [0, 3]
    >>> get_a_indexes('Greece')
    []
    """
    result = []
    low = s.lower()
    index = low.find('a')
    indexes_passed = 0
    while index != -1:
        result.append(indexes_passed + index)
        indexes_passed += index + 1
        low = low[index+1:]
        index = low.find('a')
    return result


def reverse_words(s):
    """
    Reverse each word in s, but not the entire string. A word
    is separated by spaces. See Doctests for examples
    >>> reverse_words('cat dog')
    'tac god'
    >>> reverse_words('cat-dog')
    'god-tac'
    >>> reverse_words('frankie')
    'eiknarf'
    >>> reverse_words('cs106a is a tough class')
    'a601sc si a hguot ssalc'
    """
    words = s.split()
    result = ''
    for word in words:
        # reverse the word
        reverse = ''
        for letter in word:
            reverse = letter + reverse
        # add the reversed word with a space for the next one
        result += reverse + ' '

    # don't include the last space in the return!
    return result[:-1]


def get_num_list(s):
    """
    returns a list of ints, where each int is a number from s
    Define a "number" in s as any number of digits that aren't
    separated by a non-digit. See Doctests for examples
    Doctests:
    >>> get_num_list('106A106B 11 12')
    [106, 106, 11, 12]
    >>> get_num_list('106A106B1112')
    [106, 106, 1112]
    >>> get_num_list('barbie')
    []
    >>> get_num_list('CS106A')
    [106]
    """
    # buckle up, this one is pretty wild
    # Think of this as looping through all chunks,
    # where a chunk is one number (any number of digits)
    # OR it is one letter (one digit). Note the inner loop
    # loops over the characters in a chunk, the outer loop
    # loops over chunks
    list_of_nums = []
    i = 0
    while i < len(s):
        num = ''
        # process chunk of digits (0 or more)
        while i < len(s) and s[i].isdigit():
            num += s[i]
            i += 1
        if len(num) > 0:
            list_of_nums.append(int(num))
        # process chunk of one letter
        i += 1
    return list_of_nums
