"""
Program to read in a CSV and print out each row as a list
If a column is provided, will also print out that column

Written by Frankie Cerkvenik 2023
"""

import sys

def main():
    args = sys.argv[1:]
    if len(args) < 1:
        print("please run with at least one argument, a file name and optionally a column name")
        return

    filename = args[0]

    #print everything in file
    for line in open(filename):
        line = line.strip()
        row = line.split(',')
        print(row)

    # print values in only one column of file
    if len(args) == 2:
        col = int(args[1])
        for line in open(filename):
            line = line.strip()
            row = line.split(',')
            print(row[col])




if __name__ == '__main__':
    main()