"""
Program to read in a csv of format:
 name,phonenumber
 name,phonenumber
 ...
and print out this information as a dict

Written by Frankie Cerkvenik based on lecture example by Mehran Sahami and Chris Piech
"""

import sys

def build_phonebook(filename):
    """
    filename should be a csv of this structure:
     name1, phonenumber1
     name2, phonenumber2
     ...
    Creates and returns a dictionary of this structure
    {
        name1: phonenumber1,
        name2: phonenumber2
        ...
    }
    Doctests:
    >>> build_phonebook('phone_numers_small.csv')
    {'frankie': '222-4561', 'ecy': '479-2260', 'barbie': '111-1111'}
    """
    phonebook = {}
    for line in open(filename):
        line = line.strip()
        row = line.split(',')
        name = row[0].strip()
        number = row[1].strip()
        phonebook[name] = number
    return phonebook
def main():
    args = sys.argv[1:]
    filename = args[0]
    names = args[1:]

    phonebook = build_phonebook(filename)

    for name in names:
        if name in phonebook:
            print(name + ": " + phonebook[name])
        else:
            print("No phone number for " + name)


if __name__ == '__main__':
    main()

