"""
Program to read in a csv of format:
    name1, type1, phonenumber1, type2, phonebumber2..
    name2, type3, phonenumber3
     ...
    Creates a dictionary of this structure
    {
        name1: {
            type1: phonenumber1,
            type2: phonenumber2
        }
        name2: {
            type3: phonenumber3
        }
        ...
    }
 ...
and prints this information as a dict
Written by Frankie Cerkvenik based on lecture example by Mehran Sahami and Chris Piech
"""

import sys


def get_inner_dict(types_and_nums):
    """
    Given a list ['type ', 'number', 'type', 'number', ...]
    Returns a dictionary like:
    {
        type: number,
        type: number,
        etc
    }
    Doctests:
    >>> get_inner_dict("Mehran, work,723-6059,home,555-1212,mobile,876-5432".split(','))
    {'Mehran': 'work', '723-6059': 'home', '555-1212': 'mobile'}
    """
    length = len(types_and_nums)
    # we only need to loop once for every two items
    result = {}
    for i in range(length // 2):
        cur_type = types_and_nums[i*2].strip()
        cur_phone = types_and_nums[i*2+1].strip()
        result[cur_type] = cur_phone
    return result



def build_phonebook(filename):
    """
    filename should be a csv of this structure:
     name1, type1, phonenumber1, type2, phonebumber2..
     name2, type3, phonenumber3
     ...
    Creates and returns a dictionary of this structure
    {
        name1: {
            type1: phonenumber1,
            type2: phonenumber2
        }
        name2: {
            type3: phonenumber3
        }
        ...
    }
    Doctests:
    >>> build_phonebook('phone_numbers_small.csv')
    {'Mehran': {'work': '723-6059', 'home': '555-1212', 'mobile': '876-5432'}, 'Pat': {'home': '800-2112'}, 'Jamie': {'mobile': '888-8888', 'work': '777-7777'}}
    """
    result = {}
    for line in open(filename):
        line = line.strip()
        row = line.split(',')
        name = row[0].strip()
        inner_dict = get_inner_dict(row[1:])
        result[name] = inner_dict
    return result




def main():
    args = sys.argv[1:]
    filename = args[0]
    phonebook = build_phonebook(filename)
    print(phonebook)

    # you don't need to understand this code, but
    # read ahead if curious! It makes an interactive program
    name = input("Who would you like to look up? q to stop\n")
    while name != "q":
        if name in phonebook:
            types = phonebook[name].keys()
            print(f'For name you have {len(types)} options:')
            print(list(types))
            requested_type = input("Which phone number do you want?\n")
            print(phonebook[name][requested_type])
        else:
            print(f'{name} is not in your phonebook :(')
        name = input("Who would you like to look up? q to stop\n")


if __name__ == '__main__':
    main()

