"""
Program to demo the ServiceLine class

Written by Frankie Cerkvenik 2023
"""
from service_line import ServiceLine


def big_rush(line, lots_of_people):
    for person in lots_of_people:
        line.add_person(person)

def main():
    # Make a line called DMV with an average wait time of 90mins
    dmv_line = ServiceLine("DMV", 90)
    # Make a line called Deli with an average wait time of 15 mins
    deli_line = ServiceLine("Deli", 15)

    # Frankie goes to the deli first then to the DMV
    deli_line.add_person("Frankie")
    deli_wait_time = deli_line.get_wait_time()
    print(f"Deli's wait time:{deli_wait_time}") # prints 15, only Frankie is in line

    # while frankie is at the deli, there is a big rush on the DMV
    big_rush(dmv_line, ["Ecy", "Chris", "Mehran"])
    dmv_wait_time = dmv_line.get_wait_time()
    print(f"DMV's wait time:  {dmv_wait_time}")  # prints 90*3, because 3 people just joined

    # Frankie is done with the deli
    deli_line.serve_next_person()
    print(f"Deli's wait time after Frankie leaves:  {deli_line.get_wait_time()}")  # prints 0, no one is in line

    dmv_line.add_person("Frankie")
    print(f"DMV's wait time after Frankie joins:  {dmv_line.get_wait_time()}")  # prints 90*4

if __name__ == '__main__':
    main()

